/***************************************************************************
 * SPDX-FileCopyrightText: 2023 {{cookiecutter.author}} {{cookiecutter.email}}
 * SPDX-License-Identifier: GPL-3.0-or-later
 ***************************************************************************/
/** @file
 * This file is Skrooge plugin for {{cookiecutter.plugin_name}} import / export.
 *
 * @author {{cookiecutter.__plugin_slug | upper}}
 */
#include "skgimportplugin{{cookiecutter.__plugin_slug}}.h"

#include <klocalizedstring.h>
#include <kpluginfactory.h>


#include "skgtraces.h"

/**
 * This plugin factory.
 */
K_PLUGIN_FACTORY(SKGImportPlugin{{cookiecutter.__plugin_slug}}Factory, registerPlugin<SKGImportPlugin{{cookiecutter.__plugin_slug}}>();)

SKGImportPlugin{{cookiecutter.__plugin_slug}}::SKGImportPlugin{{cookiecutter.__plugin_slug}}(QObject* iImporter, const QVariantList& iArg)
    : SKGImportPlugin(iImporter)
{
    SKGTRACEINFUNC(10)
    Q_UNUSED(iArg)
}

SKGImportPlugin{{cookiecutter.__plugin_slug}}::~SKGImportPlugin{{cookiecutter.__plugin_slug}}()
{
}

bool SKGImportPlugin{{cookiecutter.__plugin_slug}}::isImportPossible()
{
    SKGTRACEINFUNC(10)
    return (!m_importer ? true : m_importer->getFileNameExtension() == "{{cookiecutter.__plugin_slug}}");
}

SKGError SKGImportPlugin{{cookiecutter.__plugin_slug}}::importFile()
{
    return SKGImportPlugin::importFile();
}

bool SKGImportPlugin{{cookiecutter.__plugin_slug}}::isExportPossible()
{
    SKGTRACEINFUNC(10)
    return isImportPossible();
}

SKGError SKGImportPlugin{{cookiecutter.__plugin_slug}}::exportFile()
{
    return SKGImportPlugin::exportFile();
}

QString SKGImportPlugin{{cookiecutter.__plugin_slug}}::getMimeTypeFilter() const
{
    return "*.{{cookiecutter.__plugin_slug}}|" % i18nc("A file format", "{{cookiecutter.plugin_name}} file");
}


